/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.config.WitherBombCommonConfig;
import com.alexander.mutantmore.init.EntityTypeInit;
import com.alexander.mutantmore.init.ItemInit;
import com.alexander.mutantmore.init.ParticleTypeInit;
import com.alexander.mutantmore.init.SoundEventInit;
import com.alexander.mutantmore.init.TagInit;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class WitherBomb
extends ThrowableProjectile
implements IAnimatable,
IAnimationTickable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final EntityDataAccessor<Boolean> DEPLOYED = SynchedEntityData.m_135353_(WitherBomb.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> THROWN = SynchedEntityData.m_135353_(WitherBomb.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(WitherBomb.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public int deployAnimationTick;
    public int deployAnimationLength = 12;
    public int activateAnimationTick;
    public int activateAnimationLength = 67;

    public WitherBomb(EntityType<? extends WitherBomb> p_37391_, Level p_37392_) {
        super(p_37391_, p_37392_);
        this.f_19850_ = true;
    }

    public WitherBomb(Level p_37399_, LivingEntity p_37400_) {
        super((EntityType)EntityTypeInit.WITHER_BOMB.get(), p_37400_, p_37399_);
    }

    public WitherBomb(Level p_37394_, double p_37395_, double p_37396_, double p_37397_) {
        super((EntityType)EntityTypeInit.WITHER_BOMB.get(), p_37395_, p_37396_, p_37397_, p_37394_);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.f_19853_.f_46443_ && this.isOwnedBy((LivingEntity)player) && player.m_21120_(hand).m_41619_() && player.m_6047_()) {
            this.m_19998_((ItemLike)ItemInit.WITHER_BOMB.get());
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        this.tickDownAnimTimers();
        TargetingConditions targeting = TargetingConditions.m_148353_().m_26883_(((Double)WitherBombCommonConfig.detection_range.get()).doubleValue()).m_148355_().m_26893_().m_26888_(entity -> this.f_19853_ == entity.f_19853_ && EntitySelector.f_20406_.test(entity) && !entity.m_20147_() && !entity.m_21224_() && this.f_19853_.m_6857_().m_61935_(entity.m_20191_()) && !this.m_150171_((Entity)entity) && this.hasLineOfSight((Entity)entity) && !entity.m_6095_().m_204039_(TagInit.EntityTypes.WITHER_BOMB_ISNT_TRIGGERED_BY));
        int nearbyTargetables = this.f_19853_.m_45971_(LivingEntity.class, targeting, null, this.m_20191_().m_82400_(((Double)WitherBombCommonConfig.detection_range.get()).doubleValue())).size();
        if (!this.f_19853_.f_46443_) {
            if (this.isDeployed() && (nearbyTargetables > 0 || this.isThrown()) && this.activateAnimationTick <= 0) {
                this.activateAnimationTick = this.activateAnimationLength;
                this.f_19853_.m_7605_((Entity)this, (byte)1);
                this.m_5496_((SoundEvent)SoundEventInit.WITHER_BOMB_OPEN.get(), 1.5f, 1.0f);
            }
            if (this.activateAnimationTick > 1 && this.activateAnimationTick <= this.activateAnimationLength - 12) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)ParticleTypeInit.WITHER_BOMB.get()), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 3, 0.0, 0.0, 0.0, 0.0);
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)ParticleTypeInit.WITHER_SWIRL.get()), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 5, 0.0, 0.0, 0.0, 0.0);
                if (this.activateAnimationTick > 1 && this.activateAnimationTick <= this.activateAnimationLength - 30) {
                    for (LivingEntity targetable : this.f_19853_.m_45971_(LivingEntity.class, TargetingConditions.m_148352_(), null, this.m_20191_().m_82400_(((Double)WitherBombCommonConfig.damage_range.get()).doubleValue()))) {
                        if (targetable == null || targetable.m_6095_().m_204039_(TagInit.EntityTypes.WITHER_BOMB_CANT_HURT)) continue;
                        if (targetable.f_19797_ % (Integer)WitherBombCommonConfig.damage_interval.get() == 0) {
                            targetable.f_19802_ = 0;
                            targetable.m_6469_(DamageSource.f_19320_, ((Double)WitherBombCommonConfig.damage.get()).floatValue());
                        }
                        targetable.m_7292_(new MobEffectInstance(MobEffects.f_19615_, ((Integer)WitherBombCommonConfig.wither_length.get()).intValue(), ((Integer)WitherBombCommonConfig.wither_level.get()).intValue()));
                        targetable.m_7292_(new MobEffectInstance(MobEffects.f_19597_, ((Integer)WitherBombCommonConfig.slowness_length.get()).intValue(), ((Integer)WitherBombCommonConfig.slowness_level.get()).intValue()));
                        targetable.m_7292_(new MobEffectInstance(MobEffects.f_19610_, ((Integer)WitherBombCommonConfig.blindness_length.get()).intValue()));
                    }
                }
            } else if (this.activateAnimationTick == 1) {
                this.m_146870_();
            }
        }
        Vec3 vec33 = this.m_20184_();
        this.m_6478_(MoverType.SELF, vec33);
        this.m_20256_(vec33);
        HitResult hitresult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (!this.f_19794_) {
            this.m_6532_(hitresult);
            this.f_19812_ = true;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.deployAnimationTick == 1) {
                this.setDeployed(true);
            }
            if (!this.isDeployed() && this.m_20096_() && this.deployAnimationTick <= 0) {
                this.deployAnimationTick = this.deployAnimationLength;
                this.f_19853_.m_7605_((Entity)this, (byte)0);
                this.m_216990_((SoundEvent)SoundEventInit.WITHER_BOMB_DEPLOY.get());
            }
        }
    }

    public boolean hasLineOfSight(Entity p_147185_) {
        if (p_147185_.f_19853_ != this.f_19853_) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 vec31 = new Vec3(p_147185_.m_20185_(), p_147185_.m_20188_(), p_147185_.m_20189_());
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return this.f_19853_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    protected void m_37283_() {
    }

    protected boolean isMovementNoisy() {
        return false;
    }

    protected void m_8060_(BlockHitResult p_37069_) {
        BlockPos blockpos = new BlockPos((Vec3i)p_37069_.m_82425_());
        this.f_19853_.m_8055_(blockpos).m_60682_(this.f_19853_, blockpos, (Entity)this);
        this.m_20334_(0.0, 0.0, 0.0);
        super.m_8060_(p_37069_);
    }

    protected void m_6532_(HitResult result) {
        if (result.m_6662_() == HitResult.Type.MISS || !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)result)) {
            super.m_6532_(result);
        }
    }

    public void tickDownAnimTimers() {
        if (this.deployAnimationTick > 0) {
            --this.deployAnimationTick;
        }
        if (this.activateAnimationTick > 0) {
            --this.activateAnimationTick;
        }
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.activateAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wither_bomb_open", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.deployAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wither_bomb_deploy", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.isDeployed()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wither_bomb_ground", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wither_bomb_airborne", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void m_7822_(byte p_36869_) {
        if (p_36869_ == 0) {
            this.deployAnimationTick = this.deployAnimationLength;
        } else if (p_36869_ == 1) {
            this.activateAnimationTick = this.activateAnimationLength;
        } else {
            super.m_7822_(p_36869_);
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DEPLOYED, (Object)false);
        this.f_19804_.m_135372_(THROWN, (Object)false);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    public void m_7380_(CompoundTag p_21819_) {
        super.m_7380_(p_21819_);
        if (this.getOwnerUUID() != null) {
            p_21819_.m_128362_("Owner", this.getOwnerUUID());
        }
    }

    public void m_7378_(CompoundTag p_21815_) {
        UUID uuid;
        super.m_7378_(p_21815_);
        if (p_21815_.m_128403_("Owner")) {
            uuid = p_21815_.m_128342_("Owner");
        } else {
            String s = p_21815_.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID p_21817_) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(p_21817_));
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean isOwnedBy(LivingEntity p_21831_) {
        return p_21831_ == this.getOwner();
    }

    public boolean isDeployed() {
        return (Boolean)this.f_19804_.m_135370_(DEPLOYED);
    }

    public void setDeployed(boolean attached) {
        this.f_19804_.m_135381_(DEPLOYED, (Object)attached);
    }

    public boolean isThrown() {
        return (Boolean)this.f_19804_.m_135370_(THROWN);
    }

    public void setThrown(boolean attached) {
        this.f_19804_.m_135381_(THROWN, (Object)attached);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

